<?php
// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Redux' ) ) {
	return;
}

$post_id = isset($_GET['post']) ? $_GET['post'] : 0;

/* Roles array ready for options */
global $wp_roles;
$tt_roles = array();
foreach ($wp_roles->roles as $key=>$value){
    if ($key === 'administrator') {
        continue; // Skip the administrator role
    }
    $tt_roles[$key] = $value['name']; 
}
$tt_roles_tmp = array_merge(array('nope' => __("Everyone","woffice")),$tt_roles);
/* End */

/* Users array ready for options */
$tt_users = array();
$tt_users_obj = get_users(array( 'fields' => array( 'ID', 'user_nicename'),'cache_results' => false));    
foreach ($tt_users_obj as $tt_user) {
$tt_users[$tt_user->ID] = $tt_user->user_nicename; }
$tt_users_tmp = array('99999999999999' => __("Select users :","woffice")) + $tt_users;
/* End */

/* Get the revolution SLIDERS and Unyson Sliders */
$sliders = array();
$revsliders = array();
$fwsliders = array();
if (shortcode_exists('rev_slider')) {
	$sliders[0] = 'Select a slider';
	global $wpdb;
	$get_sliders = $wpdb->get_results('SELECT * FROM '.$wpdb->prefix.'revslider_sliders');
	if ($get_sliders) {
		foreach($get_sliders as $slider) {
			$revsliders[$slider->alias] = $slider->title;
		}
	}
}
if (class_exists('FW_Extension_Slider')) {
	if (!shortcode_exists('rev_slider')){
		$sliders[0] = 'Select a slider';
	}
	$fw_custom_query = get_posts( array('showposts'=> -1, 'post_type' => 'fw-slider' ));
	if ( !empty($fw_custom_query) ) { 
		foreach ( $fw_custom_query as $post ) : 
			
			$post_id = $post->ID;
			$post_title = get_the_title($post_id);
			
			$fwsliders[$post_id] = $post_title;
			
		endforeach;
		wp_reset_postdata();
	}
}
if (empty($revsliders) && empty($fwsliders)){
	$sliders[0] = 'Revolution Slider & Slider Extension are not enabled';
}
$sliders =  $sliders + $fwsliders + $revsliders;

$hastitle = function_exists('woffice_get_post_option') ? woffice_get_post_option($post_id,'hastitle') : '';
$hide_titlebox_for_page = function_exists('woffice_get_post_option') ? woffice_get_post_option($post_id,'hide_titlebox_for_page') : '';
$exclude_members = function_exists('woffice_get_post_option') ? woffice_get_post_option($post_id,'exclude_members') : '';
$exclude_roles = function_exists('woffice_get_post_option') ? woffice_get_post_option($post_id,'exclude_roles') : '';
$logged_only = function_exists('woffice_get_post_option') ? woffice_get_post_option($post_id,'logged_only') : '';
$revslider_featured = function_exists('woffice_get_post_option') ? woffice_get_post_option($post_id,'revslider_featured') : '';

$exclude_roles_exist = get_post_meta($post_id,'exclude_roles',true);
$exclude_page_roles_exist = get_post_meta($post_id,'exclude_page_roles',true);

if($exclude_roles_exist){
    update_post_meta($post_id,'exclude_page_roles',$exclude_roles_exist);
}

if($exclude_page_roles_exist){
    update_post_meta($post_id,'exclude_roles',$exclude_page_roles_exist);
}

$woffice_page_meta = "woffice_page_meta";
Redux_Metaboxes::set_box(
        $opt_name,
        array(
            'id'         => 'opt-woffice_page_meta',
            'post_types' => array('page'),
            'title'      => esc_html__( 'Page Options', 'woffice' ),
            'position'   => 'normal', // normal, advanced, side.
            'priority'   => 'high', // high, core, default, low.
            'sections'   => array(
                array(
                    'id'   =>'divider_page_meta',
                    'desc' => '',
                    'type' => 'divide'
                ),
                array(
                    'icon_class' => 'icon-large',
                    'icon'       => 'el-icon-home',
                    'title'      => esc_html__( 'Page Settings', 'woffice' ),
                    'fields'     => array(
                        array(
                            'id'       => 'disable_page_sidebar',
                            'type'     => 'switch',
                            'title'    => esc_html__( 'Disable Right Sidebar ?', 'woffice' ),
                            'desc'     => esc_html__( 'If this is checked, this will disbale the right sidebar for this page.', 'woffice' ),
                            'on'       => esc_html__('Yes','woffice'),
                            'off'      => esc_html__('No','woffice'),
                            'default'  => false,
                        ),
                        array(
                            'id'       => 'hastitle',
                            'type'     => 'switch',
                            'title'    => esc_html__( 'Hide the title', 'woffice' ),
                            'desc'     => esc_html__( 'Only the featured image will be visible, the title will be hidden.', 'woffice' ),
                            'on'       => esc_html__('Yes','woffice'),
                            'off'      => esc_html__('No','woffice'),
                            'default'  => $hastitle,
                        ),
                        array(
                            'id'       => 'hide_titlebox_for_page',
                            'type'     => 'switch',
                            'title'    => esc_html__( 'Hide Titlebox', 'woffice' ),
                            'desc'     => esc_html__( 'Hide titlebox for this page.', 'woffice' ),
                            'on'       => esc_html__('Yes','woffice'),
                            'off'      => esc_html__('No','woffice'),
                            'default'  => $hide_titlebox_for_page,
                        ),
                        array(
                            'id'       => 'exclude_members',
                            'type'     => 'select',
                            'multi'    => true,
                            'title'    => __('Exclude Members', 'woffice'),
                            'desc'     => __('The excluded members will not be able to see that page, they will receive an error message instead.', 'woffice'),
                            'hint' => array(
                                    'title'   => '',
                                    'content' => __('Help tip : Hold Ctrl to select multiple users.', 'woffice')
                            ),
                            'options'  => $tt_users,
                            'default'  => $exclude_members
                        ),    
                        array(
                            'id'       => 'exclude_page_roles',
                            'type'     => 'select',
                            'multi'    => true,
                            'title'    => __('Exclude Roles', 'woffice'), 
                            'desc'     => __('The excluded roles will not be able to see that blog post, they will receive an error message instead.', 'woffice'),
                            'options'  => $tt_roles_tmp,
                            'default'  => $exclude_roles
                        ),   
                        array(
                            'id'       => 'logged_only',
                            'type'     => 'switch',
                            'title'    => esc_html__( 'Only for logged users', 'woffice' ),
                            'desc'     => esc_html__( 'If your website is public you can hide this page from non-logged users, they will find a link to the login page.', 'woffice' ),
                            'on'       => esc_html__('Yes','woffice'),
                            'off'      => esc_html__('No','woffice'),
                            'default'  => $logged_only,
                        ),
                        array(
                            'id'       => 'revslider_featured',
                            'type'     => 'select',
                            'multi'    => false,
                            'title'    => __('Add a slider', 'woffice'),
                            'desc'     => __('This will override the page title box (image & title), you\'ll have the selected Slider instead.', 'woffice'),
                            'options'  => $sliders,
                            'default'  => $revslider_featured
                        ), 
                    ),
                ),
            ),
        )
    );