<?php
// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Redux' ) ) {
	return;
}
$post_id = isset($_GET['post']) ? $_GET['post'] : 0;

global $wp_roles;
    $tt_roles_tmp = array();
foreach ($wp_roles->roles as $key=>$value){
     if ($key === 'administrator') {
        continue; // Skip the administrator role
    }
    $tt_roles_tmp[$key] = $value['name'];
}
$tt_roles_tmp = array('nope' => __("Everyone","woffice")) + $tt_roles_tmp;

$woffice_post_meta = "woffice_post_meta";

$exclude_roles = function_exists('woffice_get_post_option') ? woffice_get_post_option($post_id,'exclude_roles') : '';
$featured_height = function_exists('woffice_get_post_option') ? woffice_get_post_option($post_id,'featured_height') : '';   
$everyone_edit = function_exists('woffice_get_post_option') ? woffice_get_post_option($post_id,'everyone_edit') : '';
$post_top_featured = function_exists('woffice_get_post_option') ? woffice_get_post_option($post_id,'post_top_featured') : '';

$post_top_featured_default = array();

if(!empty($post_top_featured)) {
    $post_top_featured_default['id'] = $post_top_featured['attachment_id'];
    $post_top_featured_default['url'] = $post_top_featured['url'];
}

$exclude_roles_exist = get_post_meta($post_id,'exclude_roles',true);
$exclude_post_roles_exist = get_post_meta($post_id,'exclude_post_roles',true);

if($exclude_roles_exist){
    update_post_meta($post_id,'exclude_post_roles',$exclude_roles_exist);
}

if($exclude_post_roles_exist){
    update_post_meta($post_id,'exclude_roles',$exclude_post_roles_exist);
}

Redux_Metaboxes::set_box(
    $opt_name,
    array(
        'id'         => 'opt-woffice_post_meta',
        'post_types' => array('post'),
        'title'      => esc_html__( 'Post Settings', 'woffice' ),
        'position'   => 'normal', // normal, advanced, side.
        'priority'   => 'high', // high, core, default, low.
        'sections'   => array(
            array(
                'id'   => 'opt-divide-woffice-post-meta',
                'type' => 'divide',
            ),
            array(
                'icon_class' => 'icon-large',
                'icon'       => 'el-icon-home',
                'title'      => esc_html__( 'Post Settings', 'woffice' ),
                'fields'     => array(
                    array(
                        'id'       => 'disable_sidebar',
                        'type'     => 'switch',
                        'title'    => esc_html__( 'Disable Right Sidebar ?', 'woffice' ),
                        'desc'     => esc_html__( 'If this is checked, this will disbale the right sidebar for this page.', 'woffice' ),
                        'on'       => esc_html__('Yes','woffice'),
                        'off'      => esc_html__('No','woffice'),
                        'default'  => false,
                    ),
                    array(
                        'id'       => 'post_top_featured',
                        'type'     => 'media',
                        'url'      => true,
                        'title'    => esc_html__( 'Top featured image (optional)', 'woffice' ),
                        'desc'     => esc_html__( 'Change the image behind the page title, otherwise we are going to use the default one.', 'woffice' ),
                        'default'  => $post_top_featured_default
                    ),
                    array(
                        'id'       => 'exclude_post_roles',
                        'type'     => 'select',
                        'multi'    => true,
                        'title'    => __('Exclude Roles', 'woffice'), 
                        'desc'     => __('The excluded roles will not be able to see that blog post, they will receive an error message instead.', 'woffice'),
                        'options'  => $tt_roles_tmp,
                        'default'  => $exclude_roles
                    ),
                    array(
                        'id'       => 'featured_height',
                        'type'     => 'text',
                        'title'    => esc_html__( 'Featured image height', 'woffice' ),
                        'default'  => $featured_height,
                        'desc'     => esc_html__( 'Only a number please', 'woffice' ),
                    ),
                    array(
                        'id'       => 'everyone_edit',
                        'type'     => 'switch',
                        'title'    => esc_html__( 'Everyone can edit ?', 'woffice' ),
                        'desc'     => esc_html__( 'If this is checked, all loggedin members with editing permissions on posts will be able to edit this post, otherwise only the author of the post and the administrators will be able to do it (This affect only the frontend).', 'woffice' ),
                        'on'       => esc_html__('Yes','woffice'),
                        'off'      => esc_html__('No','woffice'),
                        'default'  => $everyone_edit,
                    ),        
                ),
            ),
        ),
    )
);