<?php
// Exit if accessed directly.
defined('ABSPATH') || exit;

if (!class_exists('Redux_Metaboxes')) {
    return;
}

$post_id = isset($_GET['post']) ? $_GET['post'] : 0;

if (!function_exists('redux_icon_select_fa_5_free')) {
    require_once WOFFICE_CORE_PATH . 'libs/redux-framework/redux-core/inc/extensions/icon_select/font-awesome-5-free.php';
}

/* Users array ready for options */
$tt_users = array();
$tt_users_obj = get_users(array('fields' => array('ID', 'user_nicename')));
foreach ($tt_users_obj as $tt_user) {
    $tt_users[$tt_user->ID] = $tt_user->user_nicename;}
/* End */

$old_options = get_post_meta($post_id, 'fw_options', true);

$project_fields[] = array(
    'id'       => 'disable_project_sidebar',
    'type'     => 'switch',
    'title'    => esc_html__( 'Disable Right Sidebar ?', 'woffice' ),
    'desc'     => esc_html__( 'If this is checked, this will disbale the right sidebar for this page.', 'woffice' ),
    'on'       => esc_html__('Yes','woffice'),
    'off'      => esc_html__('No','woffice'),
    'default'  => false,
);

$project_fields[] = array(
    'id' => 'project_progress',
    'type' => 'button_set',
    'title' => esc_html__('Project Progress', 'woffice'),
    'desc' => esc_html__('How do you want to track the progress on this project ?', 'woffice'),
    'options' => array(
        'tasks' => __('Tasks', 'woffice'),
        'time' => __('Time', 'woffice'),
    ),
    'default' => isset($old_options['project_progress']) ? $old_options['project_progress'] : '',
);

$project_fields[] = array(
    'id' => 'project_current_status',
    'type' => 'select',
    'title' => esc_html__('Project Status', 'woffice'),
    'desc' => __('Set the project current status.', 'woffice'),
    'options' => array(
        'archived' => esc_html__('Archived', 'woffice'),
        'done' => esc_html__('Done', 'woffice'),
        'in_progress' => esc_html__('In Progress', 'woffice'),
        'in_review' => esc_html__('In Review', 'woffice'),
        'planned' => esc_html__('Planned', 'woffice')
    ),
    'default' => isset($old_options['project_current_status']) ? $old_options['project_current_status'] : 'planned',
);

$project_fields[] = array(
    'id' => 'project_date_start',
    'type' => 'datetime',
    'date-format'   => 'yy-mm-dd',
    'time-format'   => 'h:mm',
    'title' => esc_html__('Project Starting Date', 'woffice'),
    'desc' => __('Will be used for the progress bar on the single project page and in the widget.', 'woffice'),
    'default' => isset($old_options['project_date_start']) ? $old_options['project_date_start'] : '',
);

$project_fields[] = array(
    'id' => 'project_date_end',
    'type' => 'datetime',
    'date-format'   => 'yy-mm-dd',
    'time-format'   => 'h:mm',
    'title' => __('Project Ending Date', 'woffice'),
    'desc' => __('Will be used for the progress bar on the single project page and in the widget.', 'woffice'),
    'default' => isset($old_options['project_date_end']) ? $old_options['project_date_end'] : '',
);

$project_fields[] = array(
    'id' => 'project_completed',
    'type' => 'switch',
    'title' => __('Archive project', 'woffice'),
    'on' => esc_html__('Yes', 'woffice'),
    'off' => esc_html__('No', 'woffice'),
    'desc' => __('if the project have to be considered completed.', 'woffice'),
    'default' => get_post_meta($post_id, 'project_completed', true),
);

$project_fields[] = array(
    'id' => 'project_members',
    'type' => 'select',
    'multi' => true,
    'title' => __('Project Members', 'woffice'),
    'desc' => __('They will be allowed to modify the project from the single page and view it of course.', 'woffice'),
    'options' => $tt_users,
    'default' => isset($old_options['project_members']) ? $old_options['project_members'] : '',
);

$project_fields[] = array(
    'id' => 'project_edit',
    'type' => 'select',
    'title' => esc_html__('Allow edit', 'woffice'),
    'desc' => __('Allowing the frontend edit from the users allowed to see the project, this may not be a good idea if you are using the page builder on that page. You can also choose in the other options.', 'woffice'),
    'options' => array(
        'frontend-edit' => __('Frontend Edit', 'woffice'),
        'backend-edit' => __('Backend Edit link', 'woffice'),
        'no-edit' => __('No Edit icon', 'woffice'),
    ),
    'default' => isset($old_options['project_edit']) ? $old_options['project_edit'] : 'frontend-edit',
);

$project_fields[] = array(
    'id' => 'only_author_can_edit',
    'type' => 'switch',
    'title' => __('Only author can edit', 'woffice'),
    'on' => esc_html__('Yes', 'woffice'),
    'off' => esc_html__('No', 'woffice'),
    'desc' => __('If it is checked, only author and admin are able to modify the project, otherwise all members will be allowed to do it.', 'woffice'),
    'default' => isset($old_options['only_author_can_edit']) ? $old_options['only_author_can_edit'] : '',
);

$project_fields[] = array(
    'id' => 'single_project_public',
    'type' => 'select',
    'title' => __('Project visibility', 'woffice'),
    'desc' => __('If public, every users can view the project but only the members assigned to the project can edit it and its tasks.', 'woffice'),
    'options' => array(
        'default' => __('Default', 'woffice'),
        'public' => __('Public', 'woffice'),
        'private' => __('Private', 'woffice'),
    ),
    'default' => isset($old_options['single_project_public']) ? $old_options['single_project_public'] : '',
);

$project_fields[] = array(
    'id' => 'project_links',
    'type' => 'repeater',
    'title' => __('Project extern Links', 'woffice'),
    'desc' => __('You can add here extern links related to the projects.', 'woffice'),
    'full_width' => false,
    'subtitle' => '',
    'item_name' => '',
    'group_values' => true,
    'sortable' => true,
    'active' => false,
    'collapsible' => false,
    'fields' => array(
        array(
            'id' => 'title',
            'type' => 'text',
            'title' => esc_html__('Title', 'woffice'),
            'default' => '',
        ),
        array(
            'id' => 'link',
            'type' => 'text',
            'title' => esc_html__('URL', 'woffice'),
            'validate' => 'url',
            'default' => '',
        ),
        array(
            'id' => 'icon',
            'type' => 'icon_select',
            'title' => esc_html__('Icon', 'woffice'),
            'default' => '',
            'options' => redux_icon_select_fa_5_free(),
            'enqueue' => true,
            'enqueue_frontend' => false,
            'stylesheet' => 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.9.0/css/all.css',
            'prefix' => 'fa',
        ),
    ),
);

$project_fields[] = array(
    'id' => 'project_todo',
    'type' => 'switch',
    'title' => __('Project Todo', 'woffice'),
    'on' => esc_html__('Yes', 'woffice'),
    'off' => esc_html__('No', 'woffice'),
    'desc' => __('If it is checked, a todo tab will be displayed and the project members will be able to create tasks for the project. Note it\ll be overwritten if you enter a Wunderlist List ID below.', 'woffice'),
    'default' => get_post_meta($post_id, 'project_todo', true),
);

$project_fields[] = array(
    'id' => 'project_todo_lists',
    'type' => 'repeater',
    'title' => __('Project Todo tasks', 'woffice'),
    'desc' => __('It can be edited on the frontend by the projects member.', 'woffice'),
    'full_width' => false,
    'subtitle' => '',
    'item_name' => '',
    'group_values' => true,
    'sortable' => true,
    'active' => false,
    'collapsible' => false,
    'fields' => array(
        array(
            'id' => 'title',
            'type' => 'text',
            'title' => esc_html__('title', 'woffice'),
            'default' => '',
        ),
        array(
            'id' => 'done',
            'type' => 'switch',
            'on' => esc_html__('Yes', 'woffice'),
            'off' => esc_html__('No', 'woffice'),
            'title' => __('Done?', 'woffice'),
        ),
        array(
            'id' => 'urgent',
            'type' => 'switch',
            'on' => esc_html__('Yes', 'woffice'),
            'off' => esc_html__('No', 'woffice'),
            'title' => __('Urgent?', 'woffice'),
        ),
        array(
            'id' => 'review_request',
            'type' => 'switch',
            'on' => esc_html__('Yes', 'woffice'),
            'off' => esc_html__('No', 'woffice'),
            'title' => __('Request For Review?', 'woffice'),
        ),
        array(
            'id' => 'todo_reviewer',
            'type' => 'select',
            'multi' => true,
            'title' => __('Select the member for review.', 'woffice'),
            'options' => $tt_users,
            'required' => array('review_request', 'equals', true),
        ),
        array(
            'id' => 'start_date',
            'type' => 'date',
            'date-format'   => 'YYYY-MM-DD',
            'title' => esc_html__('Start Date ?', 'woffice'),
        ),
        array(
            'id' => 'date',
            'type' => 'date',
            'date-format'   => 'YYYY-MM-DD',
            'title' => esc_html__('Due Date ?', 'woffice'),
        ),
        array(
            'id' => 'note',
            'type' => 'textarea',
            'title' => esc_html__('Note ?', 'woffice'),
        ),
        array(
            'id' => 'assigned',
            'type' => 'select',
            'multi' => true,
            'title' => __('Specific member ?', 'woffice'),
            'desc' => __('If you have already some project\s member, the selected user have to be one of them.', 'woffice'),
            'options' => $tt_users,
        ),
    ),
);

//Add field Project calendar sync
if (class_exists('EventON') || defined('DP_PRO_EVENT_CALENDAR_VER')) {
    if (defined('DP_PRO_EVENT_CALENDAR_VER')) {

        global $wpdb;
        $dp_event_calendars = array();
        $dp_calendar_table = $wpdb->prefix . 'dpProEventCalendar_calendars';

        $query = "
			SELECT *
			FROM " . $dp_calendar_table . "
			ORDER BY title ASC";

        $calendars_obj = $wpdb->get_results($query, OBJECT);

        if (is_array($calendars_obj)) {
            foreach ($calendars_obj as $calendar) {
                $dp_event_calendars[$calendar->id] = $calendar->title;
            }
        }

        $project_fields[] = array(
            'id' => 'project_calendar_choice',
            'type' => 'select',
            'multi' => true,
            'title' => __('Event Calendar', 'woffice'),
            'desc' => __('Choose the desired calendar to create an event for the project. (DP Pro Event Calendar only).', 'woffice'),
            'options' => $dp_event_calendars,
            'default' => isset($old_options['project_calendar_choice']) ? $old_options['project_calendar_choice'] : '',
        );

        $project_fields[] = array(
            'id' => 'project_calendar',
            'type' => 'switch',
            'title' => __('Calendar sync', 'woffice'),
            'desc' => __('If it is checked, an event will be added to the calendar when the post is created (Compatible with EventON and DP Pro Event Calendar).', 'woffice'),
            'on' => esc_html__('Yes', 'woffice'),
            'off' => esc_html__('No', 'woffice'),
            'default' => isset($old_options['project_calendar']) ? $old_options['project_calendar'] : '',
        );
    }
}

if (class_exists('Woffice_Advanced_Tasks')) {
    $project_fields[] = array(
        'id' => 'advance_task',
        'type' => 'raw',
        'full_width' => 'true',
        'title' => esc_html__('Advanced Tasks', 'woffice'),
        'content' => '<button type="button" class="button at-view-comment">' . __("View Comment", 'woffice') . '</button><button type="button" class="button at-view-history">' . __("View History", 'woffice') . '</button><button type="button" class="button at-add-comment">' . __("Add Comment", 'woffice') . '</button>',
    );
}

//Add field Project files
if (defined('fileaway')) {
    $project_fields[] = array(
        'id' => 'project_files',
        'type' => 'switch',
        'title' => __('Project Files', 'woffice'),
        'desc' => __('If it is checked, a directory will be created in your directory 1 set in your File Away settings. See the following link for details informations :', 'woffice') . 'https://docs.woffice.io/file-away/',
        'on' => esc_html__('Yes', 'woffice'),
        'off' => esc_html__('No', 'woffice'),
        'default' => isset($old_options['project_files']) ? $old_options['project_files'] : '',
    );
}

$fields = array();
$fields = array_merge($project_fields, $fields);

Redux_Metaboxes::set_box(
    $opt_name,
    array(
        'id' => 'opt-woffice_project_meta',
        'post_types' => array('project'),
        'title' => esc_html__('Project Options', 'wpffice'),
        'position' => 'normal', // normal, advanced, side.
        'priority' => 'high', // high, core, default, low.
        'metaboxes_save_defaults' => true,
        'sections' => array(
            array(
                'id' => 'divider_project',
                'desc' => '',
                'type' => 'divide',
            ),
            array(
                'icon_class' => 'icon-large',
                'icon' => 'el-icon-home',
                'title' => esc_html__('Project Settings', 'woffice'),
                'fields' => $fields,
            ),
        ),
    ),
);