<?php

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Redux' ) ) {
	return;
}

// This is your option name where all the Redux data is stored.
$opt_name = 'woffice_theme_options'; 
$dir = dirname( __FILE__ ) . DIRECTORY_SEPARATOR;

/**
 * All the possible arguments for Redux.
 * For full documentation on arguments, please refer to: https://devs.redux.io/core/arguments/
 */
$theme = wp_get_theme(); // For use with some settings. Not necessary.
$meta_settinga = array(
	'page',
	'post',
	'wiki',
	'directory',
	'woffice-event',
	'woffice-projects'
);

foreach($meta_settinga as $key => $settings) {
	include(WOFFICE_CORE_PATH . '/theme-options/posts/' . $settings . '.php');
}
/**
 * All the possible arguments for Redux.
 * For full documentation on arguments, please refer to: https://devs.redux.io/core/arguments/
 */
$theme = wp_get_theme(); // For use with some settings. Not necessary.

// TYPICAL -> Change these values as you need/desire.
$args = array(
	// This is where your data is stored in the database and also becomes your global variable name.
	'opt_name'                  => $opt_name,

	// Name that appears at the top of your panel.
	'display_name'              => $theme->get( 'Name' ),

	// Version that appears at the top of your panel.
	'display_version'           => $theme->get( 'Version' ),

	// Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only).
	'menu_type'                 => 'submenu',

	// Show the sections below the admin menu item or not.
	'allow_sub_menu'            => true,

	// The text to appear in the admin menu.
	'menu_title'                => esc_html__( 'Woffice Theming Options', 'woffice' ),

	// The text to appear on the page title.
	'page_title'                => esc_html__( 'Woffice Theming Options', 'woffice' ),

	// Disable to create your own Google fonts loader.
	'disable_google_fonts_link' => false,

	// Show the panel pages on the admin bar.
	'admin_bar'                 => true,

	// Icon for the admin bar menu.
	'admin_bar_icon'            => 'dashicons-portfolio',

	// Priority for the admin bar menu.
	'admin_bar_priority'        => 50,

	// Sets a different name for your global variable other than the opt_name.
	'global_variable'           => $opt_name,

	// Show the time the page took to load, etc. (forced on while on localhost or when WP_DEBUG is enabled).
	'dev_mode'                  => false,

	// Enable basic customizer support.
	'customizer'                => true,

    // 'customizer_only' => true,

	// Allow the panel to open expanded.
	'open_expanded'             => false,

	// Disable the save warning when a user changes a field.
	'disable_save_warn'         => false,

	// Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
	'page_priority'             => 90,

	// For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters.
	'page_parent'               => 'themes.php',

	// Permissions needed to access the options panel.
	'page_permissions'          => 'manage_options',

	// Specify a custom URL to an icon.
	'menu_icon'                 => '',

	// Force your panel to always open to a specific tab (by id).
	'last_tab'                  => '',

	// Icon displayed in the admin panel next to your menu_title.
	'page_icon'                 => 'icon-themes',

	// Page slug used to denote the panel, will be based off page title, then menu title, then opt_name if not provided.
	'page_slug'                 => $opt_name,

	// On load save the defaults to DB before user clicks save.
	'save_defaults'             => true,

	// Display the default value next to each field when not set to the default value.
	'default_show'              => false,

	// What to print by the field's title if the value shown is default.
	'default_mark'              => '*',

	// Shows the Import/Export panel when not used as a field.
	'show_import_export'        => false,

	// The time transients will expire when the 'database' arg is set.
	'transient_time'            => 60 * MINUTE_IN_SECONDS,

	// Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output.
	'output'                    => true,

	// Allows dynamic CSS to be generated for customizer and google fonts,
	// but stops the dynamic CSS from going to the page head.
	'output_tag'                => true,

	// Disable the footer credit of Redux. Please leave if you can help it.
	'footer_credit'             => ' ',

	// If you prefer not to use the CDN for ACE Editor.
	// You may download the Redux Vendor Support plugin to run locally or embed it in your code.
	'use_cdn'                   => true,

	// Set the theme of the option panel.  Use 'wp' to use a more modern style, default is classic.
	'admin_theme'               => 'wp',

	// Enable or disable flyout menus when hovering over a menu with submenus.
	'flyout_submenus'           => true,

	'forced_dev_mode_off'		=> true,

	// Mode to display fonts (auto|block|swap|fallback|optional)
	// See: https://developer.mozilla.org/en-US/docs/Web/CSS/@font-face/font-display.
	'font_display'              => 'swap',

	// HINTS.
	'hints'                     => array(
		'icon'          => 'el el-question-sign',
		'icon_position' => 'right',
		'icon_color'    => 'lightgray',
		'icon_size'     => 'normal',
		'tip_style'     => array(
			'color'   => 'red',
			'shadow'  => true,
			'rounded' => false,
			'style'   => '',
		),
		'tip_position'  => array(
			'my' => 'top left',
			'at' => 'bottom right',
		),
		'tip_effect'    => array(
			'show' => array(
				'effect'   => 'slide',
				'duration' => '500',
				'event'    => 'mouseover',
			),
			'hide' => array(
				'effect'   => 'slide',
				'duration' => '500',
				'event'    => 'click mouseleave',
			),
		),
	),

	// FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
	// possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
	'database'                  => '',
	'network_admin'             => true,
	'search'                    => true,
	'class'						=> 'woffice-theme-options',
);

Redux::set_args( $opt_name, $args );

/*
 * ---> START SECTIONS
 */

// -> START Basic Fields
Redux::set_section(
	$opt_name,
	array(
		'title'            => esc_html__( 'Theme Options', 'woffice' ),
		'id'               => 'styling-options',
		'desc'             => esc_html__( 'These are theme color options.', 'woffice' ),
		'customizer_width' => '343px',
		'icon'             => 'el el-home',
	)
);
// generate the color,font,font option fields
require_once(WOFFICE_CORE_PATH . 'theme-options/options/theme-color.php' );
require_once(WOFFICE_CORE_PATH . 'theme-options/options/font-options.php' );

// -> START Login/Register Fields
Redux::set_section(
	$opt_name,
	array(
		'title'            => esc_html__( 'Login/Register', 'woffice' ),
		'id'               => 'login-register',
		'desc'             => esc_html__( 'These are Login/Register Options.', 'woffice' ),
		'customizer_width' => '343px',
		'icon'             => 'el el-user',
	)
);

// generate the custom code option fields
require_once(WOFFICE_CORE_PATH . 'theme-options/options/login.php' );
require_once(WOFFICE_CORE_PATH . 'theme-options/options/register.php' );
require_once(WOFFICE_CORE_PATH . 'theme-options/options/recaptcha.php' );
require_once(WOFFICE_CORE_PATH . 'theme-options/options/google.php' );
require_once(WOFFICE_CORE_PATH . 'theme-options/options/facebook.php' );

// -> START Home Dashboard Fields
Redux::set_section(
	$opt_name,
	array(
		'title'            => esc_html__( 'Home Dashboard', 'woffice' ),
		'id'               => 'home-dashboard',
		'desc'             => esc_html__( 'These are home dashboard options.', 'woffice' ),
		'customizer_width' => '343px',
		'icon'             => 'el el-dashboard',
	)
);

// generate the Home/Dashboard options
require_once(WOFFICE_CORE_PATH . 'theme-options/options/dashboard.php' );
// -> START General Fields
Redux::set_section(
	$opt_name,
	array(
		'title'            => esc_html__( 'General Options', 'woffice' ),
		'id'               => 'general-options',
		'desc'             => esc_html__( 'These are General Options.', 'woffice' ),
		'customizer_width' => '343px',
		'icon'             => 'el el-gallery',
	)
);

// generate the custom code option fields
require_once(WOFFICE_CORE_PATH . 'theme-options/options/general.php' );

// add favicon fields
require_once(WOFFICE_CORE_PATH . 'theme-options/options/favicons.php' );


// -> START Menu Fields
Redux::set_section(
	$opt_name,
	array(
		'title'            => esc_html__( 'Menu Options', 'woffice' ),
		'id'               => 'menu-options',
		'desc'             => esc_html__( 'These are menu options.', 'woffice' ),
		'customizer_width' => '343px',
		'icon'             => 'el el-credit-card',
	)
);

// generate the menu option fields
require_once(WOFFICE_CORE_PATH . 'theme-options/options/menu.php' );

// -> START Footer Fields
Redux::set_section(
	$opt_name,
	array(
		'title'            => esc_html__( 'Footer Options', 'woffice' ),
		'id'               => 'footer-options',
		'desc'             => esc_html__( 'These are Footer options.', 'woffice' ),
		'customizer_width' => '343px',
		'icon'             => 'el el-icon-qrcode',
	)
);

// generate the menu option fields
require_once(WOFFICE_CORE_PATH . 'theme-options/options/footer-hero.php');
require_once(WOFFICE_CORE_PATH . 'theme-options/options/footer.php');
require_once(WOFFICE_CORE_PATH . 'theme-options/options/copyright.php');

// -> START Titlebox Fields
Redux::set_section(
	$opt_name,
	array(
		'title'            => esc_html__( 'Title Box Options', 'woffice' ),
		'id'               => 'title-box-options',
		'desc'             => esc_html__( 'These are Title Box options.', 'woffice' ),
		'customizer_width' => '343px',
		'icon'             => 'el el-icon-qrcode',
	)
);

// generate the BuddyPress option fields
require_once(WOFFICE_CORE_PATH . 'theme-options/options/title-box.php');

if(function_exists('bp_is_active')){
	// -> START BuddyPress Fields
	Redux::set_section(
		$opt_name,
		array(
			'title'            => esc_html__( 'BuddyPress Options', 'woffice' ),
			'id'               => 'buddypress_opts',
			'desc'             => esc_html__( 'These are BuddyPress options.', 'woffice' ),
			'customizer_width' => '343px',
			'icon'             => 'el el-icon-qrcode',
		)
	);

	// generate the BuddyPress option fields
	require_once(WOFFICE_CORE_PATH . 'theme-options/options/buddypress-cover.php');
}

// -> START Custom code Fields
Redux::set_section(
	$opt_name,
	array(
		'title'            => esc_html__( 'Custom Code Options', 'woffice' ),
		'id'               => 'custom-code-options',
		'desc'             => esc_html__( 'These are Custom Code.', 'woffice' ),
		'customizer_width' => '343px',
		'icon'             => 'el-icon-brackets',
	)
);

// generate the custom code option fields
require_once(WOFFICE_CORE_PATH . 'theme-options/options/custom-code.php');
// -> START Header Bar options field
Redux::set_section(
	$opt_name,
	array(
		'title'            => esc_html__( 'Header Bar Options', 'woffice' ),
		'id'               => 'header-bar-options',
		'desc'             => esc_html__( 'Header Bar options.', 'woffice' ),
		'customizer_width' => '343px',
		'icon'             => 'el el-credit-card',
	)
);

// generate the custom code option fields
require_once(WOFFICE_CORE_PATH . 'theme-options/options/header-bar.php');

// -> START Sidebar options field
Redux::set_section(
	$opt_name,
	array(
		'title'            => esc_html__( 'Sidebar Options', 'woffice' ),
		'id'               => 'sidebar-options',
		'desc'             => esc_html__( 'Sidebar options.', 'woffice' ),
		'customizer_width' => '343px',
		'icon'             => 'el el-credit-card',
	)
);

// generate the custom code option fields
require_once(WOFFICE_CORE_PATH . 'theme-options/options/sidebar.php');

// -> START Chat options field
Redux::set_section(
	$opt_name,
	array(
		'title'            => esc_html__( 'Chat Options', 'woffice' ),
		'id'               => 'chat-options',
		'desc'             => esc_html__( 'Chat options.', 'woffice' ),
		'customizer_width' => '343px',
		'icon'             => 'el-icon-comment-alt',
	)
);

// generate the Chat option fields
require_once(WOFFICE_CORE_PATH . 'theme-options/options/chat.php');

// -> START Chat options field
Redux::set_section(
	$opt_name,
	array(
		'title'            => esc_html__( 'Blog Options', 'woffice' ),
		'id'               => 'blog-options',
		'desc'             => esc_html__( 'Blog options.', 'woffice' ),
		'customizer_width' => '343px',
		'icon'             => 'el-icon-comment-alt',
	)
);
// generate the Chat option fields
require_once(WOFFICE_CORE_PATH . 'theme-options/options/blog.php');

// -> START system status options field
Redux::set_section(
	$opt_name,
	array(
		'title'            => esc_html__( 'System Status', 'woffice' ),
		'id'               => 'system-status',
		'desc'             => esc_html__( 'System Status options.', 'woffice' ),
		'customizer_width' => '343px',
		'icon'             => 'el el-check',
	)
);

// generate the Chat option fields
require_once(WOFFICE_CORE_PATH . 'theme-options/options/system.php');
require_once(WOFFICE_CORE_PATH . 'theme-options/options/server-status.php');

// -> START system status options field
Redux::set_section(
	$opt_name,
	array(
		'title'            => esc_html__( 'Permissions', 'woffice' ),
		'id'               => 'permissions',
		'customizer_width' => '343px',
		'icon'             => 'el el-lock',
	)
);

// generate the Chat option fields
require_once(WOFFICE_CORE_PATH . 'theme-options/options/permissions.php');


// -> START system status options field
Redux::set_section(
	$opt_name,
	array(
		'title'            => esc_html__( 'Post/Wiki/Projects', 'woffice' ),
		'id'               => 'post_project_wiki',
		'customizer_width' => '343px',
		'icon'             => 'el el-pencil-alt',
	)
);

// generate the Chat option fields
require_once(WOFFICE_CORE_PATH . 'theme-options/options/post-project-wiki.php');

// -> START system status options field
Redux::set_section(
	$opt_name,
	array(
		'title'            => esc_html__( 'Theme Extensions', 'woffice' ),
		'id'               => 'theme_extentions',
		'customizer_width' => '343px',
		'icon'             => 'el el-pencil-alt',
	)
);

// generate the Chat option fields
require_once(WOFFICE_CORE_PATH . 'theme-options/options/theme-extentions.php');

if(class_exists('Woffice_OKR')){
	// -> START system status options field
	Redux::set_section(
		$opt_name,
		array(
			'title'            => esc_html__( 'Woffice OKRs', 'woffice' ),
			'id'               => 'woffice_okr_options',
			'customizer_width' => '343px',
			'icon'             => 'el el-pencil-alt',
		)
	);

	// generate the Chat option fields
	require_once(WOFFICE_CORE_PATH . 'theme-options/options/woffice-okr.php');
}

if(class_exists('WOKSS_KANBAN')){
	// -> START system status options field
	Redux::set_section(
		$opt_name,
		array(
			'title'            => esc_html__( 'Woffice Kanban', 'woffice' ),
			'id'               => 'woffice_kanban_options',
			'customizer_width' => '343px',
			'icon'             => 'el el-pencil-alt',
		)
	);

	// generate the Chat option fields
	require_once(WOFFICE_CORE_PATH . 'theme-options/options/woffice-kanban.php');
}

if(class_exists('Woffice_Team_View')){
	// -> START system status options field
	Redux::set_section(
		$opt_name,
		array(
			'title'            => esc_html__( 'Woffice Team View', 'woffice' ),
			'id'               => 'woffice_team_view_options',
			'customizer_width' => '343px',
			'icon'             => 'el el-pencil-alt',
		)
	);

	// generate the Chat option fields
	require_once(WOFFICE_CORE_PATH . 'theme-options/options/woffice-team-view.php');
}
