<?php

/**
 * The file that defines the core plugin class
 *
 * A class definition that includes attributes and functions used across both the
 * public-facing side of the site and the admin area.
 *
 * @link       https://woffice.io
 * @since      1.0.0
 *
 * @package    Woffice_Credit_System
 * @subpackage Woffice_Credit_System/admin/
 */

class Woffice_Credit_System_Admin_Viewer {

    /**
	 * Define the font-end view of the actions.
	 *
	 * Set the plugin actions for admin menu
	 *
	 * @since    1.0.0
	 */
    public function __construct() { 
        add_action( 'wp_dashboard_setup', array($this,'wocs_ai_dashboard_widgets') );
    }

    /**
	 * Add menu do WordPress Main dashboard
	 *
	 * @since    1.0.0
	 */
    public function wocs_ai_dashboard_widgets() {
        global $wp_meta_boxes;
         
        wp_add_dashboard_widget('wocs_ai_help_widget',  'Woffice Credit system',  array($this,'wocs_ai_credit_help'),null,null,'normal','high');
    }

    /**
	 * Display outout in WordPress Main dashboard
	 *
	 * @since    1.0.0
	 */
    public function wocs_ai_credit_help() {

        $available_credit = get_option('wocs_csai_avail_credit');
        
    ?>
        <div>
            <div>
                <h4><?php _e('Available AI credit is:','woffice-credits')?></h4>
                <?php echo sprintf('<strong>%s</strong>',$available_credit); ?>
            </div>
        </div>
    <?php

    }
}