<?php

/**
 * The file that defines the core plugin class
 *
 * A class definition that includes attributes and functions used across both the
 * public-facing side of the site and the admin area.
 *
 * @link       https://woffice.io
 * @since      1.0.0
 *
 * @package    Woffice_Credit_System
 * @subpackage Woffice_Credit_System/public/partials
 */

class Woffice_Credit_System_View {

    /**
	 * Define the font-end view of the actions.
	 *
	 * Set the plugin actions for font-end.
	 *
	 * @since    1.0.0
	 */
    public function __construct() {

        add_action('wp_footer',array($this,'wocs_ai_modal'));

    }

    /**
	 * Define the font-end view of the actions.
	 *
	 * Set the plugin actions modal which is show the output of ai actions.
	 *
	 * @since    1.0.0
	 */
    public function wocs_ai_modal() {
?>
    <div class="modal" id="aimodal">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
        
                <!-- Modal Header -->
                <div class="modal-header border-0">
                    <h4 class="modal-title"><?php _e('AI Result for:','woffice-credits')?> <span class="modal-title-resultfor"></span></h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
        
                <!-- Modal body -->
                <div class="modal-body">
                <div class="ai-spinner" style="display:none">
                    <span class="spinner-grow spinner-grow-sm" role="status" aria-hidden="true"></span>
                    <?php _e('Loading...')?>
                    <span class="sr-only"><?php _e('Loading...','woffice-credits')?></span>
                </div>
                    <div class="ai-listoutput"></div>
                    <div class="ai-message-wrapper d-none">
                        <div class="alert"></div>
                    </div>
                    <div class="ai-avail-credit-wrapper"> <?php _e('Remainig AI credis: ','woffice-credits')?> <span class="ai-avail-credit"><span></div>
                </div>
        
                <!-- Modal footer -->
                <div class="modal-footer border-0 justify-content-between">
                    <a class="font-rg1 woffice-ai-regeneration" href="javascript:void(0)"> <?php _e('Regenerate title','woffice-credits');?> </a>
                    <button type="button" class="btn btn-danger" data-dismiss="modal"><?php _e('Close','woffice-credits')?></button>
                </div>
        
            </div>
        </div>
    </div>
<?php

    }

}