<?php

if(!class_exists('Plugin_Item_Activator')) {

    class Plugin_Item_Activator {

        public function __construct() {
        
        }

        /**
        * Activate licence Ajax
        *
        */
        public function licence_activate(){
            
            $item_slug = isset($_POST['plugins_slug']) ? $_POST['plugins_slug'] : '';
            $item_key = isset($_POST['plugins_key']) ? sanitize_text_field($_POST['plugins_key']) : '';
            $item_store = constant(strtoupper($item_slug).'_STORE_URL');
            $item_id = constant(strtoupper($item_slug).'_ITEM_ID');
                    
            $api_params = array(
                'edd_action' => 'activate_license',
                'license'    => $item_key,
                'item_id'    => $item_id,
                'url'        => home_url(),
            );
            
            $response = wp_remote_post($item_store, array( 'timeout' => 15, 'sslverify' => false, 'body' => $api_params ) );

            // make sure the response came back okay
            if ( is_wp_error( $response ) || 200 !== wp_remote_retrieve_response_code( $response ) ) {

                $message =  ( is_wp_error( $response ) && ! empty( $response->get_error_message() ) ) ? $response->get_error_message() : __( 'An error occurred, please try again.' );
                $response = array("type" => 'unsuccessful', 'message' => $message, 'license_data' => '', 'plugins_slug' => $item_slug);
                    echo json_encode($response);
                exit();
            }  else {
                
                $license_data = json_decode( wp_remote_retrieve_body( $response ) );
                
                if ( false === $license_data->success ) {

                    switch( $license_data->error ) {

                        case 'expired' :

                            $message = sprintf(
                                __( 'Your license key expired on %s.', 'woffice' ),
                                date_i18n( get_option( 'date_format' ), strtotime( $license_data->expires, current_time( 'timestamp' ) ) )
                            );
                            break;

                        case 'disabled' :
                        case 'revoked' :

                            $message = __( 'Your license key has been disabled.', 'woffice' );
                            break;

                        case 'missing' :

                            $message = __( 'Invalid license.', 'woffice' );
                            break;

                        case 'invalid' :
                        case 'site_inactive' :

                            $message = __( 'Your license is not active for this URL.', 'woffice' );
                            break;

                        case 'item_name_mismatch' :

                            $message = sprintf( __( 'This appears to be an invalid license key for %s.', 'woffice' ),$license_data->item_name);
                            break;

                        case 'no_activations_left':

                            $message = __( 'Your license key has reached its activation limit.', 'woffice' );
                            break;

                        default :

                            $message = __( 'An error occurred, please try again.', 'woffice' );
                            break;
                    }
                    $response = array("type" => 'unsuccessful', 'message' => $message, 'license_data' => $license_data, 'plugins_slug' => $item_slug);
                    update_option( $item_slug.'_status', $license_data->license );
                    if(constant(strtoupper($item_slug).'_EDD_AJAX') == false){
                        return $response;
                    } else {
                        return $response;
                        
                    }
                exit();
                }else{
                    $message = __( 'Licence Activated.', 'woffice' );
                    $response = array("type" => 'success', 'message' => $message, 'license_data' => $license_data, 'plugins_slug' => $item_slug);
                    update_option( $item_slug.'_status', $license_data->license );
                    if(constant(strtoupper($item_slug).'_EDD_AJAX') == false){
                        return $response;
                    } else {
                        return $response;
                    }
                }

            }
            // $license_data->license will be either "valid" or "invalid"
            update_option( $item_slug.'_status', $license_data->license );

        }
        
        /**
        * Deactivate licence Ajax
        *
        */
        public function licence_deactivate(){
            $item_slug = isset($_POST['plugins_slug']) ? $_POST['plugins_slug'] : '';
            $item_key = isset($_POST['plugins_key']) ? sanitize_text_field($_POST['plugins_key']) : '';
            $item_store = constant(strtoupper($item_slug).'_STORE_URL');
            $item_id = constant(strtoupper($item_slug).'_ITEM_ID');

            $api_params = array(
                'edd_action' => 'deactivate_license',
                'license'    => $item_key,
                'item_id'    => $item_id,
                'url'        => home_url(),
            );

            // Call the custom API.
            $response = wp_remote_post( $item_store, array( 'timeout' => 15, 'sslverify' => false, 'body' => $api_params ) );
            $license_data = json_decode( wp_remote_retrieve_body( $response ) );
            // make sure the response came back okay
            if ( is_wp_error( $response ) || 200 !== wp_remote_retrieve_response_code( $response ) ) {

                if ( is_wp_error( $response ) ) {
                    $message = $response->get_error_message();
                } else {
                    $message = __( 'An error occurred, please try again.', 'woffice' );
                }
                $response = array("type" => 'unsuccessful', 'message' => $message, 'license_data' => $license_data, 'plugins_slug' => $item_slug);
                if(constant(strtoupper($item_slug).'_EDD_AJAX') == false){
                    return $response;
                } else {
                    return $response;
                }
            }

            if ( $license_data->license == 'deactivated' || $license_data->license == 'failed' ) {
                update_option( $item_slug.'_status', $license_data->license );
            }
            update_option( $item_slug.'_status', $license_data->license );
            $message = __( 'Deactivate license key successfully.', 'woffice' );
            $response = array("type" => 'success', 'message' => $message, 'license_data' => $license_data, 'plugins_slug' => $item_slug);
            if(constant(strtoupper($item_slug).'_EDD_AJAX') == false){
                 return $response;
            } else {
                return $response;
            }
        }

        public function plugin_updater($item_slug, $plugin_file) {
            if(!class_exists('EDD_SL_Plugin_Updater')) {
                include_once('./class-edd-sl-updater.php');
            }
            // retrieve our license key from the DB
            $item_key = get_option($item_slug);
            $item_store = constant(strtoupper($item_slug).'_STORE_URL');
            $item_id = constant(strtoupper($item_slug).'_ITEM_ID');
            $item_version = constant(strtoupper($item_slug).'_ITEM_VERSION');
            // setup the updater
            $edd_updater = new EDD_SL_Plugin_Updater( $item_store, $plugin_file,
                array(
                    'version'   => $item_version,	// current version number
                    'license'   => $item_key,       // license key (used get_option above to retrieve from DB)
                    'item_id'   => $item_id,       	// ID of the product
                    'beta'      => false,
                )
            );
        }
    }
}
